%-------------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      DefineRealWorldScene.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
%                 Professor Brian Wandell
%                 Professor Joyce Farrell
% Class:          PSYCH221
% File Version:   1
% Description:    This file defines the scene used to measure the color 
%                 accuracy of the sensor under test.
%-------------------------------------------------------------------------------

spectrum.wave = waveLengths;
wave = waveLengths;

fullFileName = fullfile(isetRootPath,'data','images','multispectral','StuffedAnimals_tungsten-hdrs.mat');
scene = sceneFromFile(fullFileName,'multispectral');

scene = sceneAdjustLuminance(scene,numCandelas);      % Candelas/m2
scene = sceneSet(scene,'distance',distanceToTarget);  % meters
scene = sceneSet(scene,'fov',fieldOfView);            % Field of view in degrees
scene = sceneInterpolateW(scene,spectrum.wave,1);     % Resample, preserve luminance

% It is often useful to visualize the data in the scene window
vcAddAndSelectObject('scene',scene);
if showISET == TRUE,
   sceneWindow;
end

% End of File
